# Gustolix Attendance Cloud (MVP) — Multi-Branch + Multi-Device (ZKTeco-ready)

A simple, stylish, fully functional attendance web app designed for:
- Multiple branches
- Multiple biometric devices (e.g., ZKTeco K40)
- Cloud hosting on cPanel (PHP + MySQL)
- Branch sync agent pushes logs to the cloud over HTTPS

## 1) Requirements
- PHP 8.0+ (recommended 8.1/8.2)
- MySQL 5.7+ / MariaDB 10.3+
- cPanel hosting with SSL (HTTPS)
- `mod_rewrite` not required (uses query routing)

## 2) Install (cPanel)
1. Upload the contents of `/public` to your web root (or upload entire project and set document root to `/public`).
2. Create a MySQL database + user in cPanel.
3. Import `database/install.sql` in phpMyAdmin.
4. Copy `.env.example` to `.env` and edit DB details + APP settings.
5. Visit `/` and login with:
   - **Email:** admin@example.com
   - **Password:** Admin@12345
   Change it immediately in Settings.

## 3) Branch + Devices Setup
- Create Branches
- For each branch, generate/assign an **Agent Key** (UI button)
- Create Devices (optional; you can pre-register by Serial)
- Ensure each Employee has **Device User ID** matching the enrollment ID on the ZKTeco device.

## 4) Attendance Sync (Recommended)
Use the included **Branch Sync Agent**:
- `agent/python_sync_agent.py`
- It runs inside each branch LAN (same network as devices)
- Pulls logs from ZKTeco over LAN and pushes them to your cloud app via HTTPS.

See `agent/README.md` for setup.

## 5) API
- POST `/api/v1/attendance/push`
- Secured with `branch_code` + `agent_key`
- Inserts into `attendance_raw` with de-duplication.

## Notes
- This MVP supports day shifts and basic night shift windows.
- You can expand rules (breaks, multiple IN/OUT, overtime policies) later.

© Gustolix Solutions
