# Branch Sync Agent (Python) — ZKTeco K40 LAN → Cloud HTTPS

This agent runs at the branch (same LAN as the ZKTeco devices).
It pulls attendance logs from devices and pushes to your cloud web app.

## Requirements (Branch PC)
- Python 3.10+
- Network access to devices (LAN)
- Internet access to your cloud app (HTTPS)

## Install
```bash
pip install requests pyzk
```

## Configure
Edit `agent_config.json`:
- cloud_url: your app URL (public root)
- branch_code + agent_key: from the Branch record in the web app
- devices: list of device IPs + serial numbers (serial must match Devices table)

## Run
```bash
python python_sync_agent.py
```

## Notes
- For reliability, run using Windows Task Scheduler (repeat every 1 minute) OR as a service.
- The agent de-duplicates on the cloud side using a unique key (device_id + uid + timestamp).
