<?php
use App\Core\DB;
use App\Core\Helpers;

$raw = file_get_contents('php://input');
$data = json_decode($raw ?: '[]', true);

if (!is_array($data)) {
  http_response_code(400);
  echo json_encode(['ok'=>false,'error'=>'Invalid JSON']);
  return;
}

$branch_code = strtoupper(trim((string)($data['branch_code'] ?? '')));
$agent_key   = trim((string)($data['agent_key'] ?? ''));
$device_serial = trim((string)($data['device_serial'] ?? ''));
$logs = $data['logs'] ?? [];

if ($branch_code==='' || $agent_key==='' || $device_serial==='' || !is_array($logs)) {
  http_response_code(400);
  echo json_encode(['ok'=>false,'error'=>'Missing branch_code/agent_key/device_serial/logs']);
  return;
}

$branch = DB::one("SELECT id, agent_key, is_active FROM branches WHERE code=? LIMIT 1", [$branch_code]);
if (!$branch || (int)$branch['is_active'] !== 1) {
  http_response_code(401);
  echo json_encode(['ok'=>false,'error'=>'Invalid branch']);
  return;
}
if (!hash_equals((string)$branch['agent_key'], $agent_key)) {
  http_response_code(401);
  echo json_encode(['ok'=>false,'error'=>'Invalid agent key']);
  return;
}

$device = DB::one("SELECT id, is_active FROM devices WHERE branch_id=? AND serial_no=? LIMIT 1", [(int)$branch['id'], $device_serial]);
if (!$device) {
  http_response_code(404);
  echo json_encode(['ok'=>false,'error'=>'Device not registered. Add the device serial in Devices first.']);
  return;
}
if ((int)$device['is_active'] !== 1) {
  http_response_code(403);
  echo json_encode(['ok'=>false,'error'=>'Device disabled']);
  return;
}

$ins=0; $dup=0; $bad=0;

foreach ($logs as $l) {
  if (!is_array($l)) { $bad++; continue; }
  $uid = trim((string)($l['uid'] ?? $l['user_id'] ?? $l['device_user_id'] ?? ''));
  $ts  = trim((string)($l['timestamp'] ?? $l['time'] ?? $l['log_time'] ?? ''));
  $verify = trim((string)($l['verify_type'] ?? ''));
  $punch  = trim((string)($l['punch_type'] ?? ''));

  if ($uid==='' || $ts==='') { $bad++; continue; }
  $t = strtotime($ts);
  if (!$t) { $bad++; continue; }
  $dt = date('Y-m-d H:i:s', $t);

  try {
    DB::exec("INSERT INTO attendance_raw(device_id, device_user_id, log_time, verify_type, punch_type, source, created_at)
              VALUES(?,?,?,?,?,'DEVICE',NOW())",
            [(int)$device['id'], $uid, $dt, $verify, $punch]);
    $ins++;
  } catch (Throwable $e) {
    $dup++;
  }
}

DB::exec("UPDATE devices SET last_sync_at=NOW() WHERE id=?", [(int)$device['id']]);

echo json_encode(['ok'=>true,'inserted'=>$ins,'duplicates'=>$dup,'skipped'=>$bad,'device_id'=>(int)$device['id']]);
