<?php
declare(strict_types=1);

namespace App;

use App\Core\Env;

require __DIR__ . '/core/Env.php';
Env::load(dirname(__DIR__) . '/.env', dirname(__DIR__) . '/.env.example');

date_default_timezone_set(Env::get('TIMEZONE', 'Africa/Nairobi'));

require __DIR__ . '/core/DB.php';
require __DIR__ . '/core/Helpers.php';
require __DIR__ . '/core/Csrf.php';
require __DIR__ . '/core/Auth.php';
require __DIR__ . '/core/Router.php';

session_name(Env::get('SESSION_NAME', 'gatt_sess'));
if (session_status() !== PHP_SESSION_ACTIVE) session_start();

// Stronger cookie defaults (best effort)
if (PHP_VERSION_ID >= 70300) {
  $params = session_get_cookie_params();
  setcookie(session_name(), session_id(), [
    'expires'  => 0,
    'path'     => $params['path'] ?? '/',
    'domain'   => $params['domain'] ?? '',
    'secure'   => (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off'),
    'httponly' => true,
    'samesite' => 'Lax',
  ]);
}

