<?php
declare(strict_types=1);

namespace App\Core;

final class Auth {
  public static function user(): ?array {
    return $_SESSION['user'] ?? null;
  }

  public static function check(): bool {
    return !empty($_SESSION['user']);
  }

  public static function require(): void {
    if (!self::check()) Helpers::redirect('?page=login');
  }

  public static function login(string $email, string $password): bool {
    $u = DB::one("SELECT id, name, email, password_hash, role FROM users WHERE email = ? AND is_active = 1 LIMIT 1", [$email]);
    if (!$u) return false;
    if (!password_verify($password, (string)$u['password_hash'])) return false;

    $_SESSION['user'] = [
      'id' => (int)$u['id'],
      'name' => (string)$u['name'],
      'email' => (string)$u['email'],
      'role' => (string)$u['role'],
    ];
    return true;
  }

  public static function logout(): void {
    unset($_SESSION['user']);
    session_regenerate_id(true);
  }
}
