<?php
declare(strict_types=1);

namespace App\Core;

final class Csrf {
  public static function token(): string {
    if (empty($_SESSION['csrf_token'])) {
      $_SESSION['csrf_token'] = bin2hex(random_bytes(16));
    }
    return (string)$_SESSION['csrf_token'];
  }

  public static function verify(): void {
    $t = (string)($_POST['csrf_token'] ?? '');
    if (!$t || empty($_SESSION['csrf_token']) || !hash_equals((string)$_SESSION['csrf_token'], $t)) {
      http_response_code(403);
      die('CSRF validation failed.');
    }
  }
}
