<?php
declare(strict_types=1);

namespace App\Core;

final class Env {
  private static array $data = [];

  public static function load(string $primary, string $fallback=''): void {
    self::$data = [];
    if ($fallback && is_file($fallback)) self::parse($fallback, true);
    if (is_file($primary)) self::parse($primary, false);
  }

  private static function parse(string $file, bool $onlyIfMissing): void {
    $lines = @file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) ?: [];
    foreach ($lines as $line) {
      $line = trim($line);
      if ($line === '' || str_starts_with($line, '#')) continue;
      $pos = strpos($line, '=');
      if ($pos === false) continue;
      $k = trim(substr($line, 0, $pos));
      $v = trim(substr($line, $pos + 1));
      $v = trim($v, " 	

 "'");
      if ($k === '') continue;
      if ($onlyIfMissing && array_key_exists($k, self::$data)) continue;
      self::$data[$k] = $v;
    }
  }

  public static function get(string $key, ?string $default=null): ?string {
    return self::$data[$key] ?? getenv($key) ?: $default;
  }
}
