<?php
declare(strict_types=1);

namespace App\Core;

final class Helpers {
  public static function e(?string $s): string {
    return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8');
  }

  public static function url(string $path=''): string {
    $base = rtrim((string)Env::get('APP_URL',''), '/');
    if ($path === '') return $base ?: '';
    if ($path[0] !== '/') $path = '/' . $path;
    return ($base ? $base : '') . $path;
  }

  public static function redirect(string $to): void {
    header('Location: ' . $to);
    exit;
  }

  public static function flash_set(string $type, string $msg): void {
    $_SESSION['_flash'] = ['type'=>$type, 'msg'=>$msg];
  }
  public static function flash_get(): ?array {
    $f = $_SESSION['_flash'] ?? null;
    unset($_SESSION['_flash']);
    return is_array($f) ? $f : null;
  }

  public static function now(): string { return date('Y-m-d H:i:s'); }

  public static function randKey(int $len=48): string {
    $chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_';
    $out = '';
    for ($i=0; $i<$len; $i++){
      $out .= $chars[random_int(0, strlen($chars)-1)];
    }
    return $out;
  }
}
