<?php
declare(strict_types=1);

namespace App\Core;

final class Router {
  public function dispatch(): void {
    $page = (string)($_GET['page'] ?? 'dashboard');

    // API routes
    if (str_starts_with($page, 'api/')) {
      $this->dispatchApi($page);
      return;
    }

    // Public routes
    if ($page === 'login') {
      require __DIR__ . '/../pages/login.php';
      return;
    }
    if ($page === 'logout') {
      Auth::logout();
      Helpers::redirect('?page=login');
      return;
    }

    // Protected pages
    Auth::require();

    // Layout wrapper
    require __DIR__ . '/../pages/_layout_top.php';
    $file = __DIR__ . '/../pages/' . basename($page) . '.php';
    if (is_file($file)) {
      require $file;
    } else {
      http_response_code(404);
      echo '<div class="cardx"><div class="cardx-b"><h3>Not found</h3><div class="small-muted">Page does not exist.</div></div></div>';
    }
    require __DIR__ . '/../pages/_layout_bottom.php';
  }

  private function dispatchApi(string $page): void {
    $path = substr($page, 4); // remove 'api/'
    $parts = explode('/', trim($path, '/'));
    $v = $parts[0] ?? '';
    $endpoint = $parts[1] ?? '';

    header('Content-Type: application/json; charset=utf-8');

    if ($v !== 'v1') {
      http_response_code(404);
      echo json_encode(['ok'=>false,'error'=>'Invalid API version']);
      return;
    }

    $apiFile = __DIR__ . '/../api/v1/' . basename($endpoint) . '.php';
    if (!is_file($apiFile)) {
      http_response_code(404);
      echo json_encode(['ok'=>false,'error'=>'Endpoint not found']);
      return;
    }
    require $apiFile;
  }
}
