<?php
use App\Core\Env;
use App\Core\Helpers;
use App\Core\Auth;

$appName = Env::get('APP_NAME','Gustolix Attendance');
$user = Auth::user();
$page = (string)($_GET['page'] ?? 'dashboard');

function nav_active(string $p, string $cur): string { return $p === $cur ? 'active' : ''; }
$today = date('D, d M Y');
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?= Helpers::e($appName) ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/app.css" rel="stylesheet">
</head>
<body>
<div class="app-shell">
  <aside class="sidebar">
    <div class="brand">
      <div class="logo"></div>
      <div>
        <div class="name"><?= Helpers::e($appName) ?></div>
        <div class="tag">Cloud Attendance • Multi-Branch</div>
      </div>
    </div>

    <nav class="nav flex-column gap-1">
      <a class="<?= nav_active('dashboard',$page) ?>" href="?page=dashboard">
        <span>Dashboard</span><span class="badge-mini">Live</span>
      </a>
      <a class="<?= nav_active('branches',$page) ?>" href="?page=branches"><span>Branches</span></a>
      <a class="<?= nav_active('devices',$page) ?>" href="?page=devices"><span>Devices</span></a>
      <a class="<?= nav_active('employees',$page) ?>" href="?page=employees"><span>Employees</span></a>
      <a class="<?= nav_active('shifts',$page) ?>" href="?page=shifts"><span>Shifts</span></a>
      <a class="<?= nav_active('roster',$page) ?>" href="?page=roster"><span>Roster</span></a>
      <a class="<?= nav_active('reports',$page) ?>" href="?page=reports"><span>Reports</span></a>
      <a class="<?= nav_active('import',$page) ?>" href="?page=import"><span>Import</span><span class="badge-mini">USB</span></a>
      <hr class="hr my-2">
      <a href="?page=settings" class="<?= nav_active('settings',$page) ?>"><span>Settings</span></a>
      <a href="?page=logout"><span>Logout</span></a>
    </nav>

    <div class="mt-auto pt-3 small-muted">
      <div class="d-flex justify-content-between align-items-center">
        <span><?= Helpers::e($today) ?></span>
        <span class="status ok">Online</span>
      </div>
      <div class="mt-2">Design & Powered by <b>Gustolix Solutions</b></div>
    </div>
  </aside>

  <main class="main">
    <div class="topbar">
      <div>
        <div class="h4 m-0 fw-bold"><?= Helpers::e(ucfirst($page)) ?></div>
        <div class="small-muted">Welcome, <?= Helpers::e($user['name'] ?? 'User') ?> • <?= Helpers::e($user['email'] ?? '') ?></div>
      </div>
      <div class="d-flex gap-2">
        <a class="btn btn-soft" href="?page=reports&date=<?= date('Y-m-d') ?>">Today</a>
        <a class="btn btn-glow" href="?page=roster">Assign Shifts</a>
      </div>
    </div>

    <?php $flash = Helpers::flash_get(); if ($flash): ?>
      <div class="toastx mb-3">
        <div class="fw-semibold"><?= Helpers::e(strtoupper($flash['type'] ?? 'INFO')) ?></div>
        <div class="small-muted"><?= Helpers::e($flash['msg'] ?? '') ?></div>
      </div>
    <?php endif; ?>
