<?php
use App\Core\DB;
use App\Core\Helpers;
use App\Core\Csrf;

$edit = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  Csrf::verify();
  $action = (string)($_POST['action'] ?? '');
  if ($action === 'create') {
    $code = strtoupper(trim((string)($_POST['code'] ?? '')));
    $name = trim((string)($_POST['name'] ?? ''));
    $key  = trim((string)($_POST['agent_key'] ?? ''));
    $active = (int)($_POST['is_active'] ?? 1);
    if ($code === '' || $name === '') {
      Helpers::flash_set('danger','Code and name required.');
      Helpers::redirect('?page=branches');
    }
    if ($key === '') $key = Helpers::randKey(48);
    DB::exec("INSERT INTO branches(code,name,agent_key,is_active,created_at) VALUES(?,?,?,?,NOW())", [$code,$name,$key,$active]);
    Helpers::flash_set('success','Branch created.');
    Helpers::redirect('?page=branches');
  }

  if ($action === 'update') {
    $id = (int)($_POST['id'] ?? 0);
    $code = strtoupper(trim((string)($_POST['code'] ?? '')));
    $name = trim((string)($_POST['name'] ?? ''));
    $key  = trim((string)($_POST['agent_key'] ?? ''));
    $active = (int)($_POST['is_active'] ?? 1);
    if ($key === '') $key = Helpers::randKey(48);
    DB::exec("UPDATE branches SET code=?, name=?, agent_key=?, is_active=? WHERE id=?", [$code,$name,$key,$active,$id]);
    Helpers::flash_set('success','Branch updated.');
    Helpers::redirect('?page=branches');
  }

  if ($action === 'regen_key') {
    $id = (int)($_POST['id'] ?? 0);
    $key = Helpers::randKey(60);
    DB::exec("UPDATE branches SET agent_key=? WHERE id=?", [$key,$id]);
    Helpers::flash_set('success','New Agent Key generated.');
    Helpers::redirect('?page=branches&edit='.$id);
  }

  if ($action === 'delete') {
    $id = (int)($_POST['id'] ?? 0);
    DB::exec("DELETE FROM branches WHERE id=?", [$id]);
    Helpers::flash_set('success','Branch deleted.');
    Helpers::redirect('?page=branches');
  }
}

$edit_id = (int)($_GET['edit'] ?? 0);
if ($edit_id > 0) $edit = DB::one("SELECT * FROM branches WHERE id=?", [$edit_id]);

$rows = DB::all("SELECT b.*,
  (SELECT COUNT(*) FROM devices d WHERE d.branch_id=b.id) device_count,
  (SELECT COUNT(*) FROM employees e WHERE e.branch_id=b.id) employee_count
  FROM branches b ORDER BY b.name");
?>

<div class="row g-3">
  <div class="col-lg-5">
    <div class="cardx">
      <div class="cardx-h">
        <div class="fw-bold"><?= $edit ? 'Edit Branch' : 'Add Branch' ?></div>
        <div class="small-muted">Each branch uses an Agent Key for secure log push.</div>
      </div>
      <div class="cardx-b">
        <form method="post" class="row g-3">
          <input type="hidden" name="csrf_token" value="<?= Helpers::e(Csrf::token()) ?>">
          <?php if ($edit): ?>
            <input type="hidden" name="action" value="update">
            <input type="hidden" name="id" value="<?= (int)$edit['id'] ?>">
          <?php else: ?>
            <input type="hidden" name="action" value="create">
          <?php endif; ?>

          <div class="col-md-4">
            <label class="form-label">Code</label>
            <input class="form-control" name="code" required value="<?= Helpers::e((string)($edit['code'] ?? 'BR01')) ?>" style="font-family:var(--mono)">
          </div>
          <div class="col-md-8">
            <label class="form-label">Name</label>
            <input class="form-control" name="name" required value="<?= Helpers::e((string)($edit['name'] ?? 'Main Branch')) ?>">
          </div>

          <div class="col-12">
            <label class="form-label">Agent Key</label>
            <div class="d-flex gap-2">
              <input class="form-control" name="agent_key" value="<?= Helpers::e((string)($edit['agent_key'] ?? '')) ?>" placeholder="Auto-generated if empty" style="font-family:var(--mono)">
              <?php if ($edit): ?>
                <button class="btn btn-soft" name="action" value="regen_key" type="submit">Regenerate</button>
              <?php endif; ?>
            </div>
            <div class="small-muted mt-1">Use in the sync agent config. Keep secret.</div>
          </div>

          <div class="col-md-4">
            <label class="form-label">Status</label>
            <select class="form-select" name="is_active">
              <option value="1" <?= ((string)($edit['is_active'] ?? '1')==='1'?'selected':'') ?>>Active</option>
              <option value="0" <?= ((string)($edit['is_active'] ?? '1')==='0'?'selected':'') ?>>Inactive</option>
            </select>
          </div>

          <div class="col-12 d-flex gap-2">
            <button class="btn btn-glow" type="submit"><?= $edit ? 'Save changes' : 'Create' ?></button>
            <?php if ($edit): ?><a class="btn btn-soft" href="?page=branches">Cancel</a><?php endif; ?>
          </div>
        </form>
      </div>
    </div>
  </div>

  <div class="col-lg-7">
    <div class="cardx">
      <div class="cardx-h">
        <div class="fw-bold">Branches</div>
        <div class="small-muted"><?= count($rows) ?> records</div>
      </div>
      <div class="cardx-b">
        <div class="table-responsive">
          <table class="table table-sm align-middle mb-0">
            <thead><tr>
              <th>#</th><th>Code</th><th>Name</th><th>Devices</th><th>Employees</th><th>Status</th><th></th>
            </tr></thead>
            <tbody>
              <?php if (!$rows): ?><tr><td colspan="7" class="small-muted">No branches yet.</td></tr><?php endif; ?>
              <?php foreach ($rows as $r): ?>
                <tr>
                  <td style="font-family:var(--mono)"><?= (int)$r['id'] ?></td>
                  <td style="font-family:var(--mono)"><?= Helpers::e((string)$r['code']) ?></td>
                  <td><?= Helpers::e((string)$r['name']) ?></td>
                  <td><?= (int)$r['device_count'] ?></td>
                  <td><?= (int)$r['employee_count'] ?></td>
                  <td><span class="status <?= ((int)$r['is_active']===1?'ok':'danger') ?>"><?= ((int)$r['is_active']===1?'Active':'Inactive') ?></span></td>
                  <td class="text-end">
                    <a class="btn btn-sm btn-soft" href="?page=branches&edit=<?= (int)$r['id'] ?>">Edit</a>
                    <button class="btn btn-sm btn-soft" type="button" onclick="copyText('<?= Helpers::e((string)$r['agent_key']) ?>')">Copy Key</button>
                    <form method="post" class="d-inline" onsubmit="return confirm('Delete branch?');">
                      <input type="hidden" name="csrf_token" value="<?= Helpers::e(Csrf::token()) ?>">
                      <input type="hidden" name="action" value="delete">
                      <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                      <button class="btn btn-sm btn-soft" type="submit">Delete</button>
                    </form>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
