<?php
use App\Core\DB;
use App\Core\Helpers;

$today = (string)($_GET['date'] ?? date('Y-m-d'));

$branches = DB::all("SELECT id, code, name FROM branches WHERE is_active=1 ORDER BY name");
$branch_id = (int)($_GET['branch_id'] ?? ($branches[0]['id'] ?? 0));

$kpis = [
  'employees' => 0,
  'devices' => 0,
  'logs_today' => 0,
  'late_today' => 0,
];

if ($branch_id > 0) {
  $kpis['employees'] = (int)(DB::one("SELECT COUNT(*) c FROM employees WHERE branch_id=? AND is_active=1", [$branch_id])['c'] ?? 0);
  $kpis['devices']   = (int)(DB::one("SELECT COUNT(*) c FROM devices WHERE branch_id=? AND is_active=1", [$branch_id])['c'] ?? 0);
  $kpis['logs_today']= (int)(DB::one("SELECT COUNT(*) c FROM attendance_raw ar
      JOIN devices d ON d.id=ar.device_id
      WHERE d.branch_id=? AND DATE(ar.log_time)=?", [$branch_id, $today])['c'] ?? 0);

  // late: roster shift exists; first punch after shift start + grace
  $roster = DB::all("SELECT sa.employee_id, s.start_time, s.grace_minutes
      FROM shift_assignments sa
      JOIN shifts s ON s.id=sa.shift_id
      WHERE sa.branch_id=? AND sa.work_date=?", [$branch_id, $today]);

  $late = 0;
  foreach ($roster as $r) {
    $empId = (int)$r['employee_id'];
    $start = (string)$r['start_time'];
    $grace = (int)$r['grace_minutes'];

    $first = DB::one("SELECT MIN(log_time) t FROM attendance_raw ar
        JOIN employees e ON e.device_user_id = ar.device_user_id AND e.branch_id=?
        WHERE e.id=? AND DATE(ar.log_time)=?", [$branch_id, $empId, $today]);
    if (!empty($first['t'])) {
      $shiftStart = strtotime($today . ' ' . $start) + ($grace * 60);
      $firstT = strtotime((string)$first['t']);
      if ($firstT > $shiftStart) $late++;
    }
  }
  $kpis['late_today'] = $late;
}

$recent = [];
if ($branch_id > 0) {
  $recent = DB::all("SELECT ar.log_time, ar.device_user_id, e.name employee_name, d.name device_name
    FROM attendance_raw ar
    JOIN devices d ON d.id=ar.device_id
    LEFT JOIN employees e ON e.branch_id=d.branch_id AND e.device_user_id=ar.device_user_id
    WHERE d.branch_id=?
    ORDER BY ar.log_time DESC
    LIMIT 12", [$branch_id]);
}
?>
<div class="row g-3">
  <div class="col-12">
    <div class="cardx">
      <div class="cardx-b d-flex flex-wrap gap-2 align-items-center justify-content-between">
        <form class="d-flex gap-2 align-items-center" method="get">
          <input type="hidden" name="page" value="dashboard">
          <div>
            <div class="small-muted mb-1">Branch</div>
            <select class="form-select" name="branch_id" onchange="this.form.submit()">
              <?php foreach ($branches as $b): ?>
                <option value="<?= (int)$b['id'] ?>" <?= ((int)$b['id']===$branch_id?'selected':'') ?>>
                  <?= Helpers::e($b['name']) ?> (<?= Helpers::e($b['code']) ?>)
                </option>
              <?php endforeach; ?>
            </select>
          </div>
          <div>
            <div class="small-muted mb-1">Date</div>
            <input class="form-control" type="date" name="date" value="<?= Helpers::e($today) ?>" onchange="this.form.submit()">
          </div>
        </form>
        <div class="d-flex gap-2">
          <a class="btn btn-soft" href="?page=reports&branch_id=<?= (int)$branch_id ?>&date=<?= Helpers::e($today) ?>">View Report</a>
          <a class="btn btn-glow" href="?page=devices&branch_id=<?= (int)$branch_id ?>">Manage Devices</a>
        </div>
      </div>
    </div>
  </div>

  <div class="col-md-3">
    <div class="cardx"><div class="cardx-b kpi">
      <div class="dot"></div>
      <div>
        <div class="small-muted">Active Employees</div>
        <div class="h3 m-0 fw-bold"><?= (int)$kpis['employees'] ?></div>
      </div>
    </div></div>
  </div>
  <div class="col-md-3">
    <div class="cardx"><div class="cardx-b kpi">
      <div class="dot" style="background:var(--brand1)"></div>
      <div>
        <div class="small-muted">Active Devices</div>
        <div class="h3 m-0 fw-bold"><?= (int)$kpis['devices'] ?></div>
      </div>
    </div></div>
  </div>
  <div class="col-md-3">
    <div class="cardx"><div class="cardx-b kpi">
      <div class="dot" style="background:var(--warn)"></div>
      <div>
        <div class="small-muted">Logs Today</div>
        <div class="h3 m-0 fw-bold"><?= (int)$kpis['logs_today'] ?></div>
      </div>
    </div></div>
  </div>
  <div class="col-md-3">
    <div class="cardx"><div class="cardx-b kpi">
      <div class="dot" style="background:var(--danger)"></div>
      <div>
        <div class="small-muted">Late (Rostered)</div>
        <div class="h3 m-0 fw-bold"><?= (int)$kpis['late_today'] ?></div>
      </div>
    </div></div>
  </div>

  <div class="col-12">
    <div class="cardx">
      <div class="cardx-h">
        <div class="fw-bold">Recent Activity</div>
        <div class="small-muted">Latest punches received in the cloud</div>
      </div>
      <div class="cardx-b">
        <div class="table-responsive">
          <table class="table table-sm align-middle mb-0">
            <thead><tr>
              <th>Time</th><th>Employee</th><th>Device</th><th>User ID</th>
            </tr></thead>
            <tbody>
              <?php if (!$recent): ?>
                <tr><td colspan="4" class="small-muted">No logs yet. Sync via agent or import via USB.</td></tr>
              <?php endif; ?>
              <?php foreach ($recent as $r): ?>
                <tr>
                  <td style="font-family:var(--mono)"><?= Helpers::e((string)$r['log_time']) ?></td>
                  <td><?= Helpers::e((string)($r['employee_name'] ?? 'Unknown')) ?></td>
                  <td><?= Helpers::e((string)$r['device_name']) ?></td>
                  <td style="font-family:var(--mono)"><?= Helpers::e((string)$r['device_user_id']) ?></td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>

</div>
