<?php
use App\Core\DB;
use App\Core\Helpers;
use App\Core\Csrf;

$branches = DB::all("SELECT id, name FROM branches WHERE is_active=1 ORDER BY name");
$branch_id = (int)($_GET['branch_id'] ?? ($branches[0]['id'] ?? 0));
$edit = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  Csrf::verify();
  $action = (string)($_POST['action'] ?? '');
  if ($action === 'create') {
    $branch = (int)($_POST['branch_id'] ?? 0);
    $name = trim((string)($_POST['name'] ?? ''));
    $model = trim((string)($_POST['model'] ?? 'ZKTeco K40'));
    $serial = trim((string)($_POST['serial_no'] ?? ''));
    $active = (int)($_POST['is_active'] ?? 1);
    if ($branch<=0 || $name==='' || $serial==='') {
      Helpers::flash_set('danger','Branch, name and serial are required.');
      Helpers::redirect('?page=devices');
    }
    DB::exec("INSERT INTO devices(branch_id,name,model,serial_no,is_active,created_at) VALUES(?,?,?,?,?,NOW())",
      [$branch,$name,$model,$serial,$active]);
    Helpers::flash_set('success','Device created.');
    Helpers::redirect('?page=devices&branch_id='.$branch);
  }

  if ($action === 'update') {
    $id = (int)($_POST['id'] ?? 0);
    $branch = (int)($_POST['branch_id'] ?? 0);
    $name = trim((string)($_POST['name'] ?? ''));
    $model = trim((string)($_POST['model'] ?? 'ZKTeco K40'));
    $serial = trim((string)($_POST['serial_no'] ?? ''));
    $active = (int)($_POST['is_active'] ?? 1);
    DB::exec("UPDATE devices SET branch_id=?, name=?, model=?, serial_no=?, is_active=? WHERE id=?",
      [$branch,$name,$model,$serial,$active,$id]);
    Helpers::flash_set('success','Device updated.');
    Helpers::redirect('?page=devices&branch_id='.$branch);
  }

  if ($action === 'delete') {
    $id = (int)($_POST['id'] ?? 0);
    $row = DB::one("SELECT branch_id FROM devices WHERE id=?", [$id]);
    DB::exec("DELETE FROM devices WHERE id=?", [$id]);
    Helpers::flash_set('success','Device deleted.');
    Helpers::redirect('?page=devices&branch_id='.(int)($row['branch_id'] ?? 0));
  }
}

$edit_id = (int)($_GET['edit'] ?? 0);
if ($edit_id>0) $edit = DB::one("SELECT * FROM devices WHERE id=?", [$edit_id]);

$rows = [];
if ($branch_id>0) {
  $rows = DB::all("SELECT d.*, b.name branch_name
    FROM devices d
    JOIN branches b ON b.id=d.branch_id
    WHERE d.branch_id=?
    ORDER BY d.name", [$branch_id]);
}
?>

<div class="row g-3">
  <div class="col-lg-5">
    <div class="cardx">
      <div class="cardx-h">
        <div class="fw-bold"><?= $edit ? 'Edit Device' : 'Add Device' ?></div>
        <div class="small-muted">Register by Serial Number (from device menu / sticker).</div>
      </div>
      <div class="cardx-b">
        <form method="post" class="row g-3">
          <input type="hidden" name="csrf_token" value="<?= Helpers::e(Csrf::token()) ?>">
          <?php if ($edit): ?>
            <input type="hidden" name="action" value="update">
            <input type="hidden" name="id" value="<?= (int)$edit['id'] ?>">
          <?php else: ?>
            <input type="hidden" name="action" value="create">
          <?php endif; ?>

          <div class="col-12">
            <label class="form-label">Branch</label>
            <select class="form-select" name="branch_id" required>
              <option value="">Select branch...</option>
              <?php foreach ($branches as $b): ?>
                <?php $sel = (int)($edit['branch_id'] ?? $branch_id) === (int)$b['id']; ?>
                <option value="<?= (int)$b['id'] ?>" <?= $sel ? 'selected' : '' ?>><?= Helpers::e((string)$b['name']) ?></option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="col-md-6">
            <label class="form-label">Device Name</label>
            <input class="form-control" name="name" required value="<?= Helpers::e((string)($edit['name'] ?? 'Front Desk K40')) ?>">
          </div>
          <div class="col-md-6">
            <label class="form-label">Model</label>
            <input class="form-control" name="model" value="<?= Helpers::e((string)($edit['model'] ?? 'ZKTeco K40')) ?>">
          </div>
          <div class="col-12">
            <label class="form-label">Serial No</label>
            <input class="form-control" name="serial_no" required value="<?= Helpers::e((string)($edit['serial_no'] ?? '')) ?>" style="font-family:var(--mono)">
            <div class="small-muted mt-1">Used by the sync agent to match logs.</div>
          </div>

          <div class="col-md-4">
            <label class="form-label">Status</label>
            <select class="form-select" name="is_active">
              <option value="1" <?= ((string)($edit['is_active'] ?? '1')==='1'?'selected':'') ?>>Active</option>
              <option value="0" <?= ((string)($edit['is_active'] ?? '1')==='0'?'selected':'') ?>>Inactive</option>
            </select>
          </div>

          <div class="col-12 d-flex gap-2">
            <button class="btn btn-glow" type="submit"><?= $edit ? 'Save changes' : 'Create' ?></button>
            <?php if ($edit): ?><a class="btn btn-soft" href="?page=devices&branch_id=<?= (int)$branch_id ?>">Cancel</a><?php endif; ?>
          </div>
        </form>
      </div>
    </div>
  </div>

  <div class="col-lg-7">
    <div class="cardx">
      <div class="cardx-h">
        <div class="fw-bold">Devices</div>
        <form method="get" class="d-flex gap-2 align-items-center">
          <input type="hidden" name="page" value="devices">
          <select class="form-select" name="branch_id" onchange="this.form.submit()">
            <?php foreach ($branches as $b): ?>
              <option value="<?= (int)$b['id'] ?>" <?= ((int)$b['id']===$branch_id?'selected':'') ?>><?= Helpers::e((string)$b['name']) ?></option>
            <?php endforeach; ?>
          </select>
        </form>
      </div>
      <div class="cardx-b">
        <div class="table-responsive">
          <table class="table table-sm align-middle mb-0">
            <thead><tr>
              <th>#</th><th>Name</th><th>Model</th><th>Serial</th><th>Status</th><th>Last Sync</th><th></th>
            </tr></thead>
            <tbody>
              <?php if (!$rows): ?><tr><td colspan="7" class="small-muted">No devices for this branch yet.</td></tr><?php endif; ?>
              <?php foreach ($rows as $r): ?>
                <tr>
                  <td style="font-family:var(--mono)"><?= (int)$r['id'] ?></td>
                  <td><?= Helpers::e((string)$r['name']) ?></td>
                  <td><?= Helpers::e((string)$r['model']) ?></td>
                  <td style="font-family:var(--mono)"><?= Helpers::e((string)$r['serial_no']) ?></td>
                  <td><span class="status <?= ((int)$r['is_active']===1?'ok':'danger') ?>"><?= ((int)$r['is_active']===1?'Active':'Inactive') ?></span></td>
                  <td class="small-muted" style="font-family:var(--mono)"><?= Helpers::e((string)($r['last_sync_at'] ?? '—')) ?></td>
                  <td class="text-end">
                    <a class="btn btn-sm btn-soft" href="?page=devices&branch_id=<?= (int)$branch_id ?>&edit=<?= (int)$r['id'] ?>">Edit</a>
                    <form method="post" class="d-inline" onsubmit="return confirm('Delete device?');">
                      <input type="hidden" name="csrf_token" value="<?= Helpers::e(Csrf::token()) ?>">
                      <input type="hidden" name="action" value="delete">
                      <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                      <button class="btn btn-sm btn-soft" type="submit">Delete</button>
                    </form>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
