<?php
use App\Core\DB;
use App\Core\Helpers;
use App\Core\Csrf;

$branches = DB::all("SELECT id, name FROM branches WHERE is_active=1 ORDER BY name");
$branch_id = (int)($_GET['branch_id'] ?? ($branches[0]['id'] ?? 0));
$edit = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  Csrf::verify();
  $action = (string)($_POST['action'] ?? '');
  if ($action === 'create') {
    $branch = (int)($_POST['branch_id'] ?? 0);
    $emp_no = trim((string)($_POST['emp_no'] ?? ''));
    $name = trim((string)($_POST['name'] ?? ''));
    $device_uid = trim((string)($_POST['device_user_id'] ?? ''));
    $phone = trim((string)($_POST['phone'] ?? ''));
    $active = (int)($_POST['is_active'] ?? 1);
    if ($branch<=0 || $emp_no==='' || $name==='' || $device_uid==='') {
      Helpers::flash_set('danger','Branch, Emp No, Name and Device User ID are required.');
      Helpers::redirect('?page=employees');
    }
    DB::exec("INSERT INTO employees(branch_id,emp_no,name,device_user_id,phone,is_active,created_at) VALUES(?,?,?,?,?,?,NOW())",
      [$branch,$emp_no,$name,$device_uid,$phone,$active]);
    Helpers::flash_set('success','Employee created.');
    Helpers::redirect('?page=employees&branch_id='.$branch);
  }

  if ($action === 'update') {
    $id = (int)($_POST['id'] ?? 0);
    $branch = (int)($_POST['branch_id'] ?? 0);
    $emp_no = trim((string)($_POST['emp_no'] ?? ''));
    $name = trim((string)($_POST['name'] ?? ''));
    $device_uid = trim((string)($_POST['device_user_id'] ?? ''));
    $phone = trim((string)($_POST['phone'] ?? ''));
    $active = (int)($_POST['is_active'] ?? 1);
    DB::exec("UPDATE employees SET branch_id=?, emp_no=?, name=?, device_user_id=?, phone=?, is_active=? WHERE id=?",
      [$branch,$emp_no,$name,$device_uid,$phone,$active,$id]);
    Helpers::flash_set('success','Employee updated.');
    Helpers::redirect('?page=employees&branch_id='.$branch);
  }

  if ($action === 'delete') {
    $id = (int)($_POST['id'] ?? 0);
    $row = DB::one("SELECT branch_id FROM employees WHERE id=?", [$id]);
    DB::exec("DELETE FROM employees WHERE id=?", [$id]);
    Helpers::flash_set('success','Employee deleted.');
    Helpers::redirect('?page=employees&branch_id='.(int)($row['branch_id'] ?? 0));
  }
}

$edit_id = (int)($_GET['edit'] ?? 0);
if ($edit_id>0) $edit = DB::one("SELECT * FROM employees WHERE id=?", [$edit_id]);

$rows = [];
if ($branch_id>0) {
  $rows = DB::all("SELECT e.*, b.name branch_name
    FROM employees e
    JOIN branches b ON b.id=e.branch_id
    WHERE e.branch_id=?
    ORDER BY e.name", [$branch_id]);
}
?>

<div class="row g-3">
  <div class="col-lg-5">
    <div class="cardx">
      <div class="cardx-h">
        <div class="fw-bold"><?= $edit ? 'Edit Employee' : 'Add Employee' ?></div>
        <div class="small-muted">Device User ID must match enrollment ID on the biometric device.</div>
      </div>
      <div class="cardx-b">
        <form method="post" class="row g-3">
          <input type="hidden" name="csrf_token" value="<?= Helpers::e(Csrf::token()) ?>">
          <?php if ($edit): ?>
            <input type="hidden" name="action" value="update">
            <input type="hidden" name="id" value="<?= (int)$edit['id'] ?>">
          <?php else: ?>
            <input type="hidden" name="action" value="create">
          <?php endif; ?>

          <div class="col-12">
            <label class="form-label">Branch</label>
            <select class="form-select" name="branch_id" required>
              <option value="">Select branch...</option>
              <?php foreach ($branches as $b): ?>
                <?php $sel = (int)($edit['branch_id'] ?? $branch_id) === (int)$b['id']; ?>
                <option value="<?= (int)$b['id'] ?>" <?= $sel ? 'selected' : '' ?>><?= Helpers::e((string)$b['name']) ?></option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="col-md-4">
            <label class="form-label">Emp No</label>
            <input class="form-control" name="emp_no" required value="<?= Helpers::e((string)($edit['emp_no'] ?? 'EMP001')) ?>" style="font-family:var(--mono)">
          </div>
          <div class="col-md-8">
            <label class="form-label">Full Name</label>
            <input class="form-control" name="name" required value="<?= Helpers::e((string)($edit['name'] ?? '')) ?>">
          </div>
          <div class="col-md-6">
            <label class="form-label">Device User ID</label>
            <input class="form-control" name="device_user_id" required value="<?= Helpers::e((string)($edit['device_user_id'] ?? '')) ?>" style="font-family:var(--mono)">
          </div>
          <div class="col-md-6">
            <label class="form-label">Phone</label>
            <input class="form-control" name="phone" value="<?= Helpers::e((string)($edit['phone'] ?? '')) ?>">
          </div>

          <div class="col-md-4">
            <label class="form-label">Status</label>
            <select class="form-select" name="is_active">
              <option value="1" <?= ((string)($edit['is_active'] ?? '1')==='1'?'selected':'') ?>>Active</option>
              <option value="0" <?= ((string)($edit['is_active'] ?? '1')==='0'?'selected':'') ?>>Inactive</option>
            </select>
          </div>

          <div class="col-12 d-flex gap-2">
            <button class="btn btn-glow" type="submit"><?= $edit ? 'Save changes' : 'Create' ?></button>
            <?php if ($edit): ?><a class="btn btn-soft" href="?page=employees&branch_id=<?= (int)$branch_id ?>">Cancel</a><?php endif; ?>
          </div>
        </form>
      </div>
    </div>
  </div>

  <div class="col-lg-7">
    <div class="cardx">
      <div class="cardx-h">
        <div class="fw-bold">Employees</div>
        <form method="get" class="d-flex gap-2 align-items-center">
          <input type="hidden" name="page" value="employees">
          <select class="form-select" name="branch_id" onchange="this.form.submit()">
            <?php foreach ($branches as $b): ?>
              <option value="<?= (int)$b['id'] ?>" <?= ((int)$b['id']===$branch_id?'selected':'') ?>><?= Helpers::e((string)$b['name']) ?></option>
            <?php endforeach; ?>
          </select>
        </form>
      </div>
      <div class="cardx-b">
        <div class="table-responsive">
          <table class="table table-sm align-middle mb-0">
            <thead><tr>
              <th>#</th><th>Emp No</th><th>Name</th><th>Device UID</th><th>Phone</th><th>Status</th><th></th>
            </tr></thead>
            <tbody>
              <?php if (!$rows): ?><tr><td colspan="7" class="small-muted">No employees for this branch yet.</td></tr><?php endif; ?>
              <?php foreach ($rows as $r): ?>
                <tr>
                  <td style="font-family:var(--mono)"><?= (int)$r['id'] ?></td>
                  <td style="font-family:var(--mono)"><?= Helpers::e((string)$r['emp_no']) ?></td>
                  <td><?= Helpers::e((string)$r['name']) ?></td>
                  <td style="font-family:var(--mono)"><?= Helpers::e((string)$r['device_user_id']) ?></td>
                  <td><?= Helpers::e((string)$r['phone']) ?></td>
                  <td><span class="status <?= ((int)$r['is_active']===1?'ok':'danger') ?>"><?= ((int)$r['is_active']===1?'Active':'Inactive') ?></span></td>
                  <td class="text-end">
                    <a class="btn btn-sm btn-soft" href="?page=employees&branch_id=<?= (int)$branch_id ?>&edit=<?= (int)$r['id'] ?>">Edit</a>
                    <form method="post" class="d-inline" onsubmit="return confirm('Delete employee?');">
                      <input type="hidden" name="csrf_token" value="<?= Helpers::e(Csrf::token()) ?>">
                      <input type="hidden" name="action" value="delete">
                      <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                      <button class="btn btn-sm btn-soft" type="submit">Delete</button>
                    </form>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
