<?php
use App\Core\DB;
use App\Core\Helpers;
use App\Core\Csrf;

$branches = DB::all("SELECT id, name FROM branches WHERE is_active=1 ORDER BY name");
$branch_id = (int)($_GET['branch_id'] ?? ($branches[0]['id'] ?? 0));

$devices = $branch_id>0 ? DB::all("SELECT id, name FROM devices WHERE branch_id=? ORDER BY name", [$branch_id]) : [];
$device_id = (int)($_GET['device_id'] ?? ($devices[0]['id'] ?? 0));

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  Csrf::verify();
  $branch_id = (int)($_POST['branch_id'] ?? 0);
  $device_id = (int)($_POST['device_id'] ?? 0);

  if ($branch_id<=0 || $device_id<=0) {
    Helpers::flash_set('danger','Select branch and device.');
    Helpers::redirect('?page=import');
  }

  if (empty($_FILES['file']['tmp_name'])) {
    Helpers::flash_set('danger','Upload a CSV file.');
    Helpers::redirect('?page=import&branch_id='.$branch_id.'&device_id='.$device_id);
  }

  $tmp = (string)$_FILES['file']['tmp_name'];
  $fh = fopen($tmp, 'r');
  if (!$fh) {
    Helpers::flash_set('danger','Failed to read file.');
    Helpers::redirect('?page=import&branch_id='.$branch_id.'&device_id='.$device_id);
  }

  // Expected columns (flexible):
  // uid,timestamp
  // or UserID,DateTime
  $header = fgetcsv($fh);
  if (!$header) {
    Helpers::flash_set('danger','Empty file.');
    Helpers::redirect('?page=import&branch_id='.$branch_id.'&device_id='.$device_id);
  }
  $map = [];
  foreach ($header as $i=>$h) {
    $h = strtolower(trim((string)$h));
    if (in_array($h, ['uid','userid','user_id','id'], true)) $map['uid'] = $i;
    if (in_array($h, ['timestamp','datetime','date_time','time'], true)) $map['ts'] = $i;
  }
  if (!isset($map['uid'], $map['ts'])) {
    Helpers::flash_set('danger','CSV must have uid/userid and timestamp/datetime columns.');
    Helpers::redirect('?page=import&branch_id='.$branch_id.'&device_id='.$device_id);
  }

  $ins = 0; $dup = 0; $bad = 0;
  while (($row = fgetcsv($fh)) !== false) {
    $uid = trim((string)($row[$map['uid']] ?? ''));
    $ts  = trim((string)($row[$map['ts']] ?? ''));
    if ($uid==='' || $ts==='') { $bad++; continue; }

    // try parse
    $t = strtotime($ts);
    if (!$t) { $bad++; continue; }
    $dt = date('Y-m-d H:i:s', $t);

    try {
      DB::exec("INSERT INTO attendance_raw(device_id,device_user_id,log_time,verify_type,punch_type,source,created_at)
                VALUES(?,?,?,?,?,'IMPORT',NOW())",
              [$device_id,$uid,$dt,'', '']);
      $ins++;
    } catch (Throwable $e) {
      $dup++;
    }
  }
  fclose($fh);

  Helpers::flash_set('success', "Import complete: {$ins} inserted, {$dup} duplicates, {$bad} skipped.");
  Helpers::redirect('?page=import&branch_id='.$branch_id.'&device_id='.$device_id);
}
?>

<div class="cardx mb-3">
  <div class="cardx-b d-flex flex-wrap gap-2 align-items-end justify-content-between">
    <form method="get" class="d-flex flex-wrap gap-2 align-items-end">
      <input type="hidden" name="page" value="import">
      <div>
        <div class="small-muted mb-1">Branch</div>
        <select class="form-select" name="branch_id" onchange="this.form.submit()">
          <?php foreach ($branches as $b): ?>
            <option value="<?= (int)$b['id'] ?>" <?= ((int)$b['id']===$branch_id?'selected':'') ?>><?= Helpers::e((string)$b['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div>
        <div class="small-muted mb-1">Device</div>
        <select class="form-select" name="device_id" onchange="this.form.submit()">
          <?php foreach ($devices as $d): ?>
            <option value="<?= (int)$d['id'] ?>" <?= ((int)$d['id']===$device_id?'selected':'') ?>><?= Helpers::e((string)$d['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
    </form>
    <div class="small-muted">USB fallback: export from device → upload CSV</div>
  </div>
</div>

<div class="cardx">
  <div class="cardx-h">
    <div class="fw-bold">Import Attendance Logs (CSV)</div>
    <div class="small-muted">Columns: uid/userid + timestamp/datetime</div>
  </div>
  <div class="cardx-b">
    <form method="post" enctype="multipart/form-data" class="row g-3">
      <input type="hidden" name="csrf_token" value="<?= Helpers::e(Csrf::token()) ?>">
      <input type="hidden" name="branch_id" value="<?= (int)$branch_id ?>">
      <input type="hidden" name="device_id" value="<?= (int)$device_id ?>">

      <div class="col-md-8">
        <label class="form-label">CSV File</label>
        <input class="form-control" type="file" name="file" accept=".csv,text/csv" required>
      </div>
      <div class="col-md-4 d-flex align-items-end">
        <button class="btn btn-glow w-100" type="submit">Import</button>
      </div>
    </form>
  </div>
</div>
