<?php
use App\Core\Env;
use App\Core\Helpers;
use App\Core\Auth;
use App\Core\Csrf;

$appName = Env::get('APP_NAME','Gustolix Attendance');

if (Auth::check()) Helpers::redirect('?page=dashboard');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  Csrf::verify();
  $email = trim((string)($_POST['email'] ?? ''));
  $pass  = (string)($_POST['password'] ?? '');
  if ($email === '' || $pass === '') {
    Helpers::flash_set('danger', 'Enter email and password.');
    Helpers::redirect('?page=login');
  }
  if (Auth::login($email, $pass)) {
    Helpers::redirect('?page=dashboard');
  }
  Helpers::flash_set('danger','Invalid login.');
  Helpers::redirect('?page=login');
}
$flash = Helpers::flash_get();
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?= Helpers::e($appName) ?> • Sign in</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/app.css" rel="stylesheet">
</head>
<body class="d-flex align-items-center">
<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-lg-6 col-xl-5">
      <div class="cardx">
        <div class="cardx-h">
          <div>
            <div class="h4 m-0 fw-bold"><?= Helpers::e($appName) ?></div>
            <div class="small-muted">Secure attendance for multi-branch teams</div>
          </div>
          <span class="status ok">SSL</span>
        </div>
        <div class="cardx-b">
          <?php if ($flash): ?>
            <div class="toastx mb-3">
              <div class="fw-semibold"><?= Helpers::e(strtoupper($flash['type'] ?? 'INFO')) ?></div>
              <div class="small-muted"><?= Helpers::e($flash['msg'] ?? '') ?></div>
            </div>
          <?php endif; ?>

          <form method="post" class="d-grid gap-3">
            <input type="hidden" name="csrf_token" value="<?= Helpers::e(Csrf::token()) ?>">
            <div>
              <label class="form-label">Email</label>
              <input class="form-control" type="email" name="email" autocomplete="username" required>
            </div>
            <div>
              <label class="form-label">Password</label>
              <input class="form-control" type="password" name="password" autocomplete="current-password" required>
            </div>
            <button class="btn btn-glow" type="submit">Sign in</button>
          </form>

          <hr class="hr my-4">
          <div class="small-muted">
            Default: <span style="font-family:var(--mono)">admin@example.com</span> /
            <span style="font-family:var(--mono)">Admin@12345</span>
          </div>
          <div class="small-muted mt-2">Design & Powered by <b>Gustolix Solutions</b> • <?= date('D, d M Y') ?></div>
        </div>
      </div>
    </div>
  </div>
</div>
</body>
</html>
