<?php
use App\Core\DB;
use App\Core\Helpers;

$branches = DB::all("SELECT id, name FROM branches WHERE is_active=1 ORDER BY name");
$branch_id = (int)($_GET['branch_id'] ?? ($branches[0]['id'] ?? 0));
$date = (string)($_GET['date'] ?? date('Y-m-d'));
if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $date)) $date = date('Y-m-d');

$rows = [];
if ($branch_id>0) {
  $roster = DB::all("SELECT sa.employee_id, e.name employee_name, e.emp_no, e.device_user_id,
      s.name shift_name, s.start_time, s.end_time, s.grace_minutes
    FROM shift_assignments sa
    JOIN employees e ON e.id=sa.employee_id
    JOIN shifts s ON s.id=sa.shift_id
    WHERE sa.branch_id=? AND sa.work_date=?
    ORDER BY e.name", [$branch_id,$date]);

  foreach ($roster as $r) {
    $uid = (string)$r['device_user_id'];

    $startTs = strtotime($date.' '.$r['start_time']);
    $endTs = strtotime($date.' '.$r['end_time']);
    // night shift: end next day
    if ($endTs <= $startTs) $endTs = strtotime($date.' '.$r['end_time'].' +1 day');

    // window around shift (2h before, 4h after)
    $from = date('Y-m-d H:i:s', $startTs - 2*3600);
    $to   = date('Y-m-d H:i:s', $endTs + 4*3600);

    $logs = DB::one("SELECT MIN(log_time) first_in, MAX(log_time) last_out
      FROM attendance_raw ar
      JOIN devices d ON d.id=ar.device_id
      WHERE d.branch_id=? AND ar.device_user_id=? AND ar.log_time BETWEEN ? AND ?", [$branch_id,$uid,$from,$to]);

    $first = $logs['first_in'] ?? null;
    $last  = $logs['last_out'] ?? null;

    $status = 'ABSENT';
    $lateMin = 0;
    if ($first) {
      $status = 'PRESENT';
      $shiftStartGrace = $startTs + ((int)$r['grace_minutes'] * 60);
      $firstTs = strtotime((string)$first);
      if ($firstTs > $shiftStartGrace) {
        $lateMin = (int)ceil(($firstTs - $shiftStartGrace)/60);
        $status = 'LATE';
      }
    }
    $rows[] = [
      'emp_no'=>$r['emp_no'],
      'employee_name'=>$r['employee_name'],
      'shift_name'=>$r['shift_name'],
      'first_in'=>$first,
      'last_out'=>$last,
      'late_minutes'=>$lateMin,
      'status'=>$status,
    ];
  }
}
?>

<div class="cardx mb-3">
  <div class="cardx-b d-flex flex-wrap gap-2 align-items-end justify-content-between">
    <form method="get" class="d-flex flex-wrap gap-2 align-items-end">
      <input type="hidden" name="page" value="reports">
      <div>
        <div class="small-muted mb-1">Branch</div>
        <select class="form-select" name="branch_id" onchange="this.form.submit()">
          <?php foreach ($branches as $b): ?>
            <option value="<?= (int)$b['id'] ?>" <?= ((int)$b['id']===$branch_id?'selected':'') ?>><?= Helpers::e((string)$b['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div>
        <div class="small-muted mb-1">Date</div>
        <input class="form-control" type="date" name="date" value="<?= Helpers::e($date) ?>" onchange="this.form.submit()">
      </div>
    </form>
    <div class="d-flex gap-2">
      <a class="btn btn-soft" href="?page=reports&branch_id=<?= (int)$branch_id ?>&date=<?= Helpers::e(date('Y-m-d', strtotime($date.' -1 day'))) ?>">Prev</a>
      <a class="btn btn-soft" href="?page=reports&branch_id=<?= (int)$branch_id ?>&date=<?= Helpers::e(date('Y-m-d', strtotime($date.' +1 day'))) ?>">Next</a>
    </div>
  </div>
</div>

<div class="cardx">
  <div class="cardx-h">
    <div class="fw-bold">Daily Attendance</div>
    <div class="small-muted"><?= count($rows) ?> rostered employees • computed from raw logs</div>
  </div>
  <div class="cardx-b">
    <?php if (!$rows): ?>
      <div class="small-muted">No roster entries for this day. Assign shifts in Roster.</div>
    <?php else: ?>
      <div class="table-responsive">
        <table class="table table-sm align-middle mb-0">
          <thead><tr>
            <th>Emp No</th><th>Employee</th><th>Shift</th><th>First In</th><th>Last Out</th><th>Late (mins)</th><th>Status</th>
          </tr></thead>
          <tbody>
            <?php foreach ($rows as $r): ?>
              <?php
                $cls = 'ok';
                if ($r['status']==='LATE') $cls='warn';
                if ($r['status']==='ABSENT') $cls='danger';
              ?>
              <tr>
                <td style="font-family:var(--mono)"><?= Helpers::e((string)$r['emp_no']) ?></td>
                <td><?= Helpers::e((string)$r['employee_name']) ?></td>
                <td><?= Helpers::e((string)$r['shift_name']) ?></td>
                <td style="font-family:var(--mono)"><?= Helpers::e((string)($r['first_in'] ?? '—')) ?></td>
                <td style="font-family:var(--mono)"><?= Helpers::e((string)($r['last_out'] ?? '—')) ?></td>
                <td style="font-family:var(--mono)"><?= (int)$r['late_minutes'] ?></td>
                <td><span class="status <?= $cls ?>"><?= Helpers::e((string)$r['status']) ?></span></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    <?php endif; ?>
  </div>
</div>
