<?php
use App\Core\DB;
use App\Core\Helpers;
use App\Core\Csrf;

$branches = DB::all("SELECT id, name FROM branches WHERE is_active=1 ORDER BY name");
$branch_id = (int)($_GET['branch_id'] ?? ($branches[0]['id'] ?? 0));
$start = (string)($_GET['start'] ?? date('Y-m-d'));
$days = (int)($_GET['days'] ?? 7);
if ($days < 1) $days = 7;
if ($days > 14) $days = 14;

$shifts = $branch_id>0 ? DB::all("SELECT id, name FROM shifts WHERE branch_id=? AND is_active=1 ORDER BY name", [$branch_id]) : [];
$employees = $branch_id>0 ? DB::all("SELECT id, name FROM employees WHERE branch_id=? AND is_active=1 ORDER BY name", [$branch_id]) : [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  Csrf::verify();
  $branch_id = (int)($_POST['branch_id'] ?? 0);
  $work_date = (string)($_POST['work_date'] ?? '');
  $employee_id = (int)($_POST['employee_id'] ?? 0);
  $shift_id = (int)($_POST['shift_id'] ?? 0);

  if ($branch_id<=0 || $employee_id<=0 || $shift_id<=0 || !preg_match('/^\d{4}-\d{2}-\d{2}$/', $work_date)) {
    Helpers::flash_set('danger','Invalid roster input.');
    Helpers::redirect('?page=roster&branch_id='.$branch_id);
  }

  $exists = DB::one("SELECT id FROM shift_assignments WHERE branch_id=? AND employee_id=? AND work_date=? LIMIT 1",
    [$branch_id,$employee_id,$work_date]);
  if ($exists) {
    DB::exec("UPDATE shift_assignments SET shift_id=? WHERE id=?", [$shift_id, (int)$exists['id']]);
  } else {
    DB::exec("INSERT INTO shift_assignments(branch_id,employee_id,shift_id,work_date,created_at) VALUES(?,?,?,?,NOW())",
      [$branch_id,$employee_id,$shift_id,$work_date]);
  }
  Helpers::flash_set('success','Roster saved.');
  Helpers::redirect('?page=roster&branch_id='.$branch_id.'&start='.$work_date.'&days='.$days);
}

$grid = [];
if ($branch_id>0) {
  $to = date('Y-m-d', strtotime($start . ' +' . ($days-1) . ' day'));
  $rows = DB::all("SELECT sa.employee_id, sa.work_date, sa.shift_id
    FROM shift_assignments sa
    WHERE sa.branch_id=? AND sa.work_date BETWEEN ? AND ?", [$branch_id, $start, $to]);
  foreach ($rows as $r) {
    $grid[(int)$r['employee_id']][(string)$r['work_date']] = (int)$r['shift_id'];
  }
}

$dates = [];
for ($i=0; $i<$days; $i++){
  $dates[] = date('Y-m-d', strtotime($start . " +{$i} day"));
}
?>

<div class="cardx mb-3">
  <div class="cardx-b d-flex flex-wrap gap-2 align-items-end justify-content-between">
    <form method="get" class="d-flex flex-wrap gap-2 align-items-end">
      <input type="hidden" name="page" value="roster">
      <div>
        <div class="small-muted mb-1">Branch</div>
        <select class="form-select" name="branch_id" onchange="this.form.submit()">
          <?php foreach ($branches as $b): ?>
            <option value="<?= (int)$b['id'] ?>" <?= ((int)$b['id']===$branch_id?'selected':'') ?>><?= Helpers::e((string)$b['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div>
        <div class="small-muted mb-1">Start</div>
        <input class="form-control" type="date" name="start" value="<?= Helpers::e($start) ?>" onchange="this.form.submit()">
      </div>
      <div>
        <div class="small-muted mb-1">Days</div>
        <select class="form-select" name="days" onchange="this.form.submit()">
          <?php foreach ([7,10,14] as $d): ?>
            <option value="<?= $d ?>" <?= ($d===$days?'selected':'') ?>><?= $d ?></option>
          <?php endforeach; ?>
        </select>
      </div>
    </form>
    <div class="small-muted">Tip: Click a cell to assign a shift.</div>
  </div>
</div>

<div class="cardx">
  <div class="cardx-h">
    <div class="fw-bold">Roster Grid</div>
    <div class="small-muted"><?= count($employees) ?> employees • <?= count($shifts) ?> shifts</div>
  </div>
  <div class="cardx-b">
    <?php if (!$branch_id): ?>
      <div class="small-muted">Create a branch first.</div>
    <?php elseif (!$shifts): ?>
      <div class="small-muted">Create shifts for this branch first.</div>
    <?php elseif (!$employees): ?>
      <div class="small-muted">Create employees for this branch first.</div>
    <?php else: ?>
      <div class="table-responsive">
        <table class="table table-sm align-middle mb-0">
          <thead>
            <tr>
              <th>Employee</th>
              <?php foreach ($dates as $d): ?>
                <th style="min-width:140px">
                  <div class="fw-semibold"><?= date('D', strtotime($d)) ?></div>
                  <div class="small-muted" style="font-family:var(--mono)"><?= Helpers::e($d) ?></div>
                </th>
              <?php endforeach; ?>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($employees as $e): ?>
              <tr>
                <td class="fw-semibold"><?= Helpers::e((string)$e['name']) ?></td>
                <?php foreach ($dates as $d): $cur = (int)($grid[(int)$e['id']][$d] ?? 0); ?>
                  <td>
                    <form method="post" class="d-flex gap-2">
                      <input type="hidden" name="csrf_token" value="<?= Helpers::e(Csrf::token()) ?>">
                      <input type="hidden" name="branch_id" value="<?= (int)$branch_id ?>">
                      <input type="hidden" name="employee_id" value="<?= (int)$e['id'] ?>">
                      <input type="hidden" name="work_date" value="<?= Helpers::e($d) ?>">
                      <select class="form-select form-select-sm" name="shift_id" onchange="this.form.submit()">
                        <option value="0">—</option>
                        <?php foreach ($shifts as $s): ?>
                          <option value="<?= (int)$s['id'] ?>" <?= ((int)$s['id']===$cur?'selected':'') ?>><?= Helpers::e((string)$s['name']) ?></option>
                        <?php endforeach; ?>
                      </select>
                    </form>
                  </td>
                <?php endforeach; ?>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    <?php endif; ?>
  </div>
</div>
