<?php
use App\Core\DB;
use App\Core\Helpers;
use App\Core\Csrf;
use App\Core\Auth;

$user = Auth::user();
$uid = (int)($user['id'] ?? 0);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  Csrf::verify();
  $name = trim((string)($_POST['name'] ?? ''));
  $email = trim((string)($_POST['email'] ?? ''));
  $pass = (string)($_POST['password'] ?? '');
  $pass2= (string)($_POST['password2'] ?? '');

  if ($name==='' || $email==='') {
    Helpers::flash_set('danger','Name and email required.');
    Helpers::redirect('?page=settings');
  }

  DB::exec("UPDATE users SET name=?, email=? WHERE id=?", [$name,$email,$uid]);

  if ($pass !== '' || $pass2 !== '') {
    if ($pass !== $pass2) {
      Helpers::flash_set('danger','Passwords do not match.');
      Helpers::redirect('?page=settings');
    }
    if (strlen($pass) < 8) {
      Helpers::flash_set('danger','Password must be at least 8 characters.');
      Helpers::redirect('?page=settings');
    }
    $hash = password_hash($pass, PASSWORD_DEFAULT);
    DB::exec("UPDATE users SET password_hash=? WHERE id=?", [$hash,$uid]);
  }

  // refresh session data
  $_SESSION['user']['name'] = $name;
  $_SESSION['user']['email'] = $email;

  Helpers::flash_set('success','Settings updated.');
  Helpers::redirect('?page=settings');
}

$row = DB::one("SELECT name,email FROM users WHERE id=?", [$uid]) ?: ['name'=>'','email'=>''];
?>
<div class="row g-3">
  <div class="col-lg-7">
    <div class="cardx">
      <div class="cardx-h">
        <div class="fw-bold">Account</div>
        <div class="small-muted">Update admin profile & password.</div>
      </div>
      <div class="cardx-b">
        <form method="post" class="row g-3">
          <input type="hidden" name="csrf_token" value="<?= Helpers::e(Csrf::token()) ?>">
          <div class="col-md-6">
            <label class="form-label">Name</label>
            <input class="form-control" name="name" value="<?= Helpers::e((string)$row['name']) ?>" required>
          </div>
          <div class="col-md-6">
            <label class="form-label">Email</label>
            <input class="form-control" name="email" type="email" value="<?= Helpers::e((string)$row['email']) ?>" required>
          </div>

          <div class="col-md-6">
            <label class="form-label">New Password</label>
            <input class="form-control" name="password" type="password" placeholder="Leave blank to keep current">
          </div>
          <div class="col-md-6">
            <label class="form-label">Confirm Password</label>
            <input class="form-control" name="password2" type="password" placeholder="Confirm">
          </div>

          <div class="col-12">
            <button class="btn btn-glow" type="submit">Save</button>
          </div>
        </form>

        <hr class="hr my-4">
        <div class="small-muted">
          API endpoint: <span style="font-family:var(--mono)">?page=api/v1/attendance_push</span>
        </div>
      </div>
    </div>
  </div>
</div>
